library(ggplot2)
library(scales)
library(plyr)

commission_measures <- read.csv("./commission_directives_and_regulations.csv", header = TRUE)

commission_measures_plot  <- ggplot(data = commission_measures, aes(x=year, y=all)) +
    geom_bar(stat = "identity", colour = "white", fill = "black") +
    theme_bw() +
    annotate("rect", xmin = 1972, xmax = 1987, ymin=-0.5, ymax=35.5, alpha=.2) +
    annotate("rect", xmin = 2004, xmax = 2019, ymin=-0.5, ymax=35.5, alpha=.2) +
    geom_smooth(method = "loess", se = F, colour = "green") +
    labs(x = "Year", y = "Measures Adopted")

commission_measures_plot

